var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmTimeCustom = $("#frmTimeCustom"),
			$frmDefaultTime = $("#frmDefaultTime"),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
		
		if ($frmDefaultTime.length > 0) {
			$frmDefaultTime.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmTimeCustom.length > 0) {
			
			$.validator.addMethod('greaterThan',
			    function (value) { 
					var  start_hour = parseInt($('#start_hour').val(), 10),
				     	 start_min =  parseInt($('#start_minute').val(), 10),
				     	 end_hour =  parseInt($('#end_hour').val(), 10),
				     	 end_min =  parseInt($('#end_minute').val(), 10);
					
					if(end_hour < start_hour)
					{
						return false;
					}else if(end_hour == start_hour){
						if(end_min <= start_min)
						{
							return false;
						}else{
							return true;
						}
					}else{
						return true;
					}
			    }, myLabel.validate_time);
			$frmTimeCustom.validate({
				messages: {
					"end_hour": {
						greaterThan: myLabel.validate_time
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminTime&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminTime&action=pjActionDeleteDate&id={:id}"}
				          ],
				columns: [{text: myLabel.date, type: "date", sortable: true, editable: false, renderer: $.datagrid._formatDate, dateFormat: pjGrid.jsDateFormat},
				          {text: myLabel.start_time, type: "text", sortable: true, editable: false},
				          {text: myLabel.end_time, type: "date", sortable: true, editable: false},
				          {text: myLabel.is_day_off, type: "text", sortable: true, editable: false}],
				dataUrl: "index.php?controller=pjAdminTime&action=pjActionGetDate",
				dataType: "json",
				fields: ['date', 'start_time', 'end_time', 'is_dayoff'],
				paginator: {
					actions: [
							   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminTime&action=pjActionDeleteDateBulk", render: true, confirmation: myLabel.delete_confirmation}
							],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".working-day", function (e) {
			var checked = $(this).is(":checked"),
				$tr = $(this).closest("tr");
			$tr.find("select, input[type='text']").attr("disabled", checked);
		}).on("focusin", ".datepick", function (e) {
			var $this = $(this);
			$this.datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev")
			});
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click", "#is_dayoff", function (e) {
			var checked = $(this).is(":checked");
			if(checked == true)
			{
				$('#end_hour').removeClass('greaterThan');
				$('.customeTimeRow').hide();
			}else{
				$('#end_hour').addClass('greaterThan');
				$('.customeTimeRow').show();
			}
		});
	});
})(jQuery_1_8_2);