<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/menu_restaurant.php';
	?>
	
	<div id="tabs">
		<ul>
			<li><a href="#tabs-1"><?php __('lblUpdate', false, true); ?></a></li>
		</ul>
		<div id="tabs-1">
			<?php
			$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
			$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
			
			list($sh, $sm,) = explode(":", $tpl['arr']['start_time']);
			list($eh, $em,) = explode(":", $tpl['arr']['end_time']);
				
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTime&amp;action=pjActionIndex" method="post" class="form pj-form" id="frmTimeCustom">
				<input type="hidden" name="custom_time" value="1" />
				
				<p>
					<label class="title"><?php __('lblDate'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date" id="date" class="pj-form-field pointer w80 datepick required" value="<?php echo pjUtil::formatDate($tpl['arr']['date'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</p>
				<p class="customeTimeRow" style="display:<?php echo $tpl['arr']['is_dayoff'] == 'T' ? 'none' : NULL; ?>;">
					<label class="title"><?php __('lblStartTime'); ?></label>
					<span class="inline_block">
					<?php
					echo pjTime::factory()
						->attr('name', 'start_hour')
						->attr('id', 'start_hour')
						->attr('class', 'pj-form-field')
						->prop('selected', $sh)
						->hour();
					?>
					<?php
					echo pjTime::factory()
						->attr('name', 'start_minute')
						->attr('id', 'start_minute')
						->attr('class', 'pj-form-field')
						->prop('selected', $sm)
						->prop('step', 5)
						->minute();
					?>
					</span>
				</p>
				<p class="customeTimeRow" style="display:<?php echo $tpl['arr']['is_dayoff'] == 'T' ? 'none' : NULL; ?>;">
					<label class="title"><?php __('lblEndTime'); ?></label>
					<span class="inline_block">
					<?php
					echo pjTime::factory()
						->attr('name', 'end_hour')
						->attr('id', 'end_hour')
						->attr('class', 'pj-form-field' . ($tpl['arr']['is_dayoff'] == 'F' ? ' greaterThan' : NULL))
						->prop('selected', $eh)
						->hour();
					?>
					<?php
					echo pjTime::factory()
						->attr('name', 'end_minute')
						->attr('id', 'end_minute')
						->attr('class', 'pj-form-field')
						->prop('selected', $eh)
						->prop('step', 5)
						->minute();
					?>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblIsDayOff'); ?></label>
					<span class="left"><input type="checkbox" name="is_dayoff" id="is_dayoff" value="T"<?php echo $tpl['arr']['is_dayoff'] == 'T' ? ' checked="checked"' : NULL; ?> /></span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminTime&action=pjActionIndex&tab_id=tabs-2';" />
				</p>
			</form>
		</div>
	</div>
	<script type="text/javascript">
	
	var myLabel = myLabel || {};
	myLabel.date = "<?php __('lblDate', false, true); ?>";
	myLabel.validate_time = "<?php __('lblValidateTime', false, true); ?>";
	myLabel.start_time = "<?php __('lblStartTime', false, true); ?>";
	myLabel.end_time = "<?php __('lblEndTime', false, true); ?>";
	myLabel.is_day_off = "<?php __('lblIsDayOff', false, true); ?>";
	</script>
	<?php
	
}
?>