<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/menu_restaurant.php';
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMaps&amp;action=pjActionIndex" method="post" id="frmUpdateMap" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="map_update" value="1" />
		<input type="hidden" name="id" value="1" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<?php pjUtil::printNotice(__('infoMapTitle', true, false), __('infoMapDesc', true, false), false);?>
		<p>
			<label class="title"><?php __('lblUseSeatMap'); ?></label>
			<span class="left"><input type="checkbox" name="use_map" id="use_map" value="1|0::1" <?php echo (int) $tpl['option_arr']['o_use_map'] == 1 ? ' checked="checked"' : NULL; ?> /></span>
		</p>
		<div id="boxMap">
			<?php
			$map = PJ_UPLOAD_PATH . 'maps/map.jpg'; 
			if (is_file($map)){
				$size = getimagesize($map);
				?>
				<div id="mapHolder" style="position: relative; overflow: hidden; width: <?php echo $size[0]; ?>px; height: <?php echo $size[1]; ?>px; margin: 0 auto;">
					<img id="map" src="<?php echo $map; ?>" alt="" style="margin: 0; border: none; position: absolute; top: 0; left: 0; z-index: 500" />
					<?php
					foreach ($tpl['seat_arr'] as $seat)
					{
						?><span rel="hi_<?php echo $seat['id']; ?>" class="rect empty" style="width: <?php echo $seat['width']; ?>px; height: <?php echo $seat['height']; ?>px; left: <?php echo $seat['left']; ?>px; top: <?php echo $seat['top']; ?>px; line-height: <?php echo $seat['height']; ?>px"><span class="rbInnerRect" data-name="hi_<?php echo $seat['id']; ?>"><?php echo stripslashes($seat['name']); ?></span></span><?php
					}
					?>
				</div>
				<div id="hiddenHolder">
					<?php
					foreach ($tpl['seat_arr'] as $seat)
					{
						?><input id="hi_<?php echo $seat['id']; ?>" type="hidden" name="seats[]" value="<?php echo join("|", array($seat['id'], $seat['width'], $seat['height'], $seat['left'], $seat['top'], $seat['name'], $seat['seats'], $seat['minimum'])); ?>" /><?php
					}
					?>
				</div>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnDelete', false, true); ?>" class="pj-button pj-delete-button" lang="1"/>
				</p>
				
				<div id="dialogDelete" title="<?php __('lblDeleteMap'); ?>" style="display:none">
					<p><?php __('lblDeleteMapConfirm'); ?></p>
				</div>
				<div id="dialogUpdate" title="<?php __('lblUpdateMapTitle'); ?>" style="display:none">
					<p><?php __('lblUpdateMapDesc'); ?></p>
					<br/>
					<div class="form pj-form">
						<p>
							<label class="title"><?php __('lblName', false, true); ?></label>
							<input type="text" name="seat_name" id="seat_name" class="pj-form-field w220" />
						</p>
						<p>
							<label class="title"><?php __('lblCapacity', false, true); ?></label>
							<input type="text" name="seat_seats" id="seat_seats" class="pj-form-field w50" />
						</p>
						<p>
							<label class="title"><?php __('lblMinimum', false, true); ?></label>
							<input type="text" name="seat_minimum" id="seat_minimum" class="pj-form-field w50" />
							<em style="display: none;"><label id="validate_seats" class="err"><?php __('lblValidateMinimum', false, true); ?></label></em>
						</p>
					</div>
				</div>
				<?php
			}else{
				?>
				<p>
					<label class="title"><?php __('lblFile'); ?></label>
					<input type="file" name="path" id="path" class="pj-form-field" />
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
				</p>
				<?php
			}
			?>
		</div>
	</form>
	
	<?php
}
?>