<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminBookings extends pjAdmin
{
	public function pjActionCheckUID()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['uuid']) || empty($_GET['uuid']))
			{
				echo 'false';
				exit;
			}
			$pjBookingModel = pjBookingModel::factory()->where('t1.uuid', $_GET['uuid']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjBookingModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjBookingModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCheckDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
			{
				$dt_from = strtotime(pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour'] . ':' . $_POST['minute'] . ' ' . strtoupper($_POST['ampm']));
				$dt_to = strtotime(pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour_to'] . ':' . $_POST['minute_to'] . ' ' . strtoupper($_POST['ampm_to']));
			}else{
				$dt_from = sprintf("%s %s:%s:00", pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']), $_POST['hour'], $_POST['minute']);
				$dt_to = sprintf("%s %s:%s:00", pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']), $_POST['hour_to'], $_POST['minute_to']);
				$dt_from = strtotime($dt_from);
				$dt_to = strtotime($dt_to);
			}
			echo $dt_to > $dt_from ? 'true' : 'false';
		}
		exit;
	}
	public function pjActionCheckTable()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['table_id']))
			{
				$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				$booking_length = $this->option_arr['o_booking_length'] * 60;
				if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
				{
					$start_time = strtotime(pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour'] . ':' . $_POST['minute'] . ' ' . strtoupper($_POST['ampm']));
					$end_time = $start_time + $booking_length;
				}else{
					$start_time = strtotime(sprintf("%s %s:%s:00", $date, $_POST['hour'], $_POST['minute']));
					$end_time = $start_time + $booking_length;
				}
				
				$table_id_arr = array();
				$_arr = explode("&", $_POST['table_id']);
								
				foreach($_arr as $v)
				{
					list(, $_id) = explode("=", $v);
					$table_id_arr[] = $_id;
				}
				
				$sub_str = '';
				if(isset($_POST['id']))
				{
					$sub_str = " AND (`id` <> '".$_POST['id']."')";
				}
				
				$sub_query = sprintf("(SELECT COUNT(`table_id`)
										FROM `%1\$s`
										WHERE `table_id` = `t1`.`id`
										AND `booking_id` IN (SELECT `id` FROM `%2\$s` WHERE ( (`dt` BETWEEN '%3\$s' AND '%4\$s') OR (`dt_to` BETWEEN '%3\$s' AND '%4\$s') OR ('%3\$s' BETWEEN `dt` AND `dt_to`) OR ('%4\$s' BETWEEN `dt` AND `dt_to`)) AND (`status` = 'confirmed' OR `status`='pending')$sub_str)
										LIMIT 1)",
										pjBookingTableModel::factory()->getTable(),
										pjBookingModel::factory()->getTable(),
										date('Y-m-d H:i:s', $start_time), 
										date('Y-m-d H:i:s', $end_time)
									);
				$table_arr = pjTableModel::factory()->select("t1.*, $sub_query AS booked")->findAll()->getData();
				foreach ($table_arr as $table)
				{
					if((int)$table['booked'] != 0)
					{
						if(in_array($table['id'], $table_id_arr))
						{
							echo 'false';
							exit;
						}
					}
				}
				echo 'true';
			}else{
				echo 'false';
			}
		}
		exit;
	}
		
	private function _getSchedule($date, $wt_arr)
	{
		$arr = pjTableModel::factory()->orderBy("id ASC")->findAll()->getData();
		foreach ($arr as $k => $table)
		{
			$arr[$k]['hour_arr'] = pjBookingModel::factory()->getBookings($table['id'], $date, $wt_arr);
		}
		return $arr;
	}
	
	public function pjActionSchedule()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$date = date("Y-m-d");
			
			$wt_arr = pjAppController::getWorkingTime($date);
			$arr = $this->_getSchedule($date, $wt_arr);
			
			$this->set('arr', $arr);
			$this->set('wt_arr', $wt_arr);
			
			$pjWorkingTimeModel = pjWorkingTimeModel::factory();
			$pjDateModel = pjDateModel::factory();
			$week_dayoff_arr = $pjWorkingTimeModel->getDaysOff(1);
			$date_arr = $pjDateModel->where("(t1.date > DATE(NOW()))")->orderBy('`date` ASC')->findAll()->getData();
			$this->set('week_dayoff_arr', $week_dayoff_arr);
			$this->set('date_arr', $date_arr);
			
			$this->appendJs('pjAdminBookings.js');
		} else {
			$this->set('status', 2);
		}
	}

	public function pjActionPaper()
	{
		$this->setLayout('pjActionEmpty');
		
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if(isset($_GET['date']))
			{
				$date = pjUtil::formatDate($_GET['date'], $this->option_arr['o_date_format']);
				$wt_arr = pjAppController::getWorkingTime($date);
				$arr = $this->_getSchedule($date, $wt_arr);
				
				$this->set('arr', $arr);
				$this->set('wt_arr', $wt_arr);
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetSchedule()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$date = pjUtil::formatDate($_GET['date'], $this->option_arr['o_date_format']);
			$wt_arr = pjAppController::getWorkingTime($date);
			$arr = $this->_getSchedule($date, $wt_arr);
			
			$this->set('arr', $arr);
			$this->set('wt_arr', $wt_arr);
		}
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			
			$this->set('table_arr', pjTableModel::factory()->orderBy('t1.name ASC')->findAll()->getData());
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminBookings.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetBooking()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBookingModel = pjBookingModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjBookingModel->where('t1.c_fname LIKE', "%$q%");
				$pjBookingModel->orWhere('t1.c_lname LIKE', "%$q%");
				$pjBookingModel->orWhere('t1.c_email LIKE', "%$q%");
			}
			if (isset($_GET['name']) && !empty($_GET['name']))
			{
				$q = pjObject::escapeString($_GET['name']);
				$pjBookingModel->where('t1.c_fname LIKE', "%$q%");
				$pjBookingModel->orWhere('t1.c_lname LIKE', "%$q%");
			}
			if (isset($_GET['email']) && !empty($_GET['email']))
			{
				$q = pjObject::escapeString($_GET['email']);
				$pjBookingModel->where('t1.c_email LIKE', "%$q%");
			}
			if (isset($_GET['phone']) && !empty($_GET['phone']))
			{
				$q = pjObject::escapeString($_GET['phone']);
				$pjBookingModel->where('t1.c_phone LIKE', "%$q%");
			}
			if (isset($_GET['date_from']) && !empty($_GET['date_from']) && isset($_GET['date_to']) && !empty($_GET['date_to']))
			{
				$df = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
				$dt = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
				$pjBookingModel->where("(DATE(t1.dt) BETWEEN '$df' AND '$dt')");
				
			} else {
				if (isset($_GET['date_from']) && !empty($_GET['date_from']))
				{
					$df = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
					$pjBookingModel->where("(DATE(t1.dt) >= '$df')");
				} elseif (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
					$dt = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
					$pjBookingModel->where("(DATE(t1.dt) <= '$df')");
				}
			}
			if (isset($_GET['table_id']) && (int) $_GET['table_id'] > 0)
			{
				$pjBookingModel->where("(t1.id IN(SELECT TBT.booking_id FROM `".pjBookingTableModel::factory()->getTable()."` as TBT WHERE TBT.table_id = ".$_GET['table_id']."))");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('confirmed','cancelled','pending','enquiry')))
			{
				$pjBookingModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjBookingModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjBookingModel->select('t1.*')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
			foreach($data as $k => $v){
				$name_arr = array();
				if(!empty($v['c_fname'])){
					$name_arr[] = pjSanitize::clean($v['c_fname']);
				}
				if(!empty($v['c_lname'])){
					$name_arr[] = pjSanitize::clean($v['c_lname']);
				}
				$v['dt'] = date($this->option_arr['o_date_format'], strtotime($v['dt'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['dt']));
				$v['full_name'] = join(" ", $name_arr);
				$data[$k]  = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionSaveBooking()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBookingModel = pjBookingModel::factory();
			$pjBookingTableModel = pjBookingTableModel::factory();
			if($_POST['column'] == 'status')
			{
				$arr = $pjBookingModel->find($_GET['id'])->getData();
				if(!empty($arr))
				{
					if(($arr['status'] != 'pending' && $arr['status'] != 'confirmed') && ($_POST['value'] == 'pending' || $_POST['value'] == 'confirmed'))
					{
						$start_time = strtotime($arr['dt']);
						$end_time = strtotime($arr['dt_to']);
						$sub_query = sprintf("(SELECT COUNT(`table_id`)
									FROM `%1\$s`
									WHERE `table_id` = `t1`.`id`
									AND `booking_id` IN (SELECT `id` FROM `%2\$s` WHERE (
										(UNIX_TIMESTAMP(`dt`) <= '%4\$u' AND UNIX_TIMESTAMP(`dt`) > '%3\$u')
										OR (UNIX_TIMESTAMP(`dt_to`) <= '%4\$u' AND UNIX_TIMESTAMP(`dt_to`) > '%3\$u')
									) AND (`status` = 'confirmed' OR `status`='pending'))
									LIMIT 1)",
								$pjBookingTableModel->getTable(),
								$pjBookingModel->getTable(),
								$start_time,
								$end_time);
						$valid = true;
						$booking_table_arr = $pjBookingTableModel->where('t1.booking_id', $arr['id'])->limit(1)->findAll()->getData();
						if(count($booking_table_arr) == 1)
						{
							$table_id = $booking_table_arr[0]['table_id'];
							$table_arr = pjTableModel::factory()->select("t1.*, $sub_query AS booked")->find($table_id)->getData();
							if((int) $table_arr['booked'] > 0)
							{
								$valid = false;
							}
						}
						if($valid == true)
						{
							$pjBookingModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
						}
					}else{
						$pjBookingModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
					}
				}
			}else{
				$pjBookingModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionExportBooking()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjBookingModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Bookings-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionDeleteBooking()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjBookingModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjBookingTableModel::factory()->where('booking_id', $_GET['id'])->eraseAll();
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteBookingBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjBookingModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjBookingTableModel::factory()->whereIn('booking_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['booking_update']))
			{
				$data = array();
				
				$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
				{
					$time = date('H:i:s', strtotime(pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour'] . ':' . $_POST['minute'] . ' ' . strtoupper($_POST['ampm'])));
				}else{
					$time = $_POST['hour'] . ":" . $_POST['minute'] . ":00";
				}
				$date_to = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
				if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
				{
					$time_to = date('H:i:s', strtotime(pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour_to'] . ':' . $_POST['minute_to'] . ' ' . strtoupper($_POST['ampm'])));
				}else{
					$time_to = $_POST['hour_to'] . ":" . $_POST['minute_to'] . ":00";
				}
				
				$data['dt'] = sprintf("%s %s", $date, $time); unset($_POST['date']);
				$data['dt_to'] = sprintf("%s %s", $date_to, $time_to); unset($_POST['date_to']);
				
				if (isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_year'] . '-' . $_POST['cc_exp_month'];
				}
				$opts = pjAppController::getPrice($this->option_arr, $date, $time, $_POST['code']);
				
				$stop = false;
				if (!$stop)
				{
					pjBookingModel::factory()->set('id', $_POST['id'])->modify(array_merge($_POST, $data));
					
					$pjBookingTableModel = pjBookingTableModel::factory();
					$pjBookingTableModel->where('booking_id', $_POST['id'])->eraseAll();
					if (isset($_POST['table_id']) && count($_POST['table_id']) > 0)
					{
						$data = array();
						$data['booking_id'] = $_POST['id'];
						foreach ($_POST['table_id'] as $table_id)
						{
							$data['table_id'] = $table_id;
							$pjBookingTableModel->reset()->setAttributes($data)->insert();
						}
					}
					$err = 'AB05';
				}
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminBookings&action=pjActionIndex&err=$err");
			}else{
				$pjTableModel = pjTableModel::factory();
				$pjBookingTableModel = pjBookingTableModel::factory();
				
				$arr = pjBookingModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminBookings&action=pjActionIndex&err=AB08");
				}
				$pjBookingTableModel->join('pjBooking', "t2.id = t1.booking_id AND t2.status = 'confirmed' AND `dt` < '".$arr['dt_to']."' AND `dt_to` > '".$arr['dt']."'", 'inner');
				$bt_arr = $pjBookingTableModel->where("t1.booking_id != " . $arr['id'])->findAll()->getDataPair('table_id', 'table_id');
				
				if (count($bt_arr) > 0){
					$pjTableModel->where("(t1.id NOT IN('".join("','", $bt_arr)."'))");
				}
				$table_arr = $pjTableModel->orderBy("t1.name ASC")->findAll()->getData();
				
				$bt_arr = $pjBookingTableModel->reset()->where('t1.booking_id', $arr['id'])->findAll()->getDataPair('id', 'table_id');
				
				$country_arr = pjCountryModel::factory()
							->select('t1.id, t2.content AS country_title')
							->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->where('status', 'T')
							->orderBy('`country_title` ASC')->findAll()->getData();
				
				$date = date('Y-m-d', strtotime($arr['dt']));
				$time = date('H:i:s', strtotime($arr['dt']));
	
				$price_arr = pjAppController::getPrice($this->option_arr, $date, $time, $arr['code']);

				$this->set('arr', $arr);
				$this->set('table_arr', $table_arr);
				$this->set('bt_arr', $bt_arr);
				$this->set('country_arr', $country_arr);
				$this->set('discount', isset($price_arr['discount_formated']) ? $price_arr['discount_formated'] : '');
				
				$pjWorkingTimeModel = pjWorkingTimeModel::factory();
				$pjDateModel = pjDateModel::factory();
				$week_dayoff_arr = $pjWorkingTimeModel->getDaysOff(1);
				$date_arr = $pjDateModel->where("(t1.date > DATE(NOW()))")->orderBy('`date` ASC')->findAll()->getData();
				$this->set('week_dayoff_arr', $week_dayoff_arr);
				$this->set('date_arr', $date_arr);
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminBookings.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['booking_create']))
			{
				$pjBookingModel = pjBookingModel::factory();
				
				$data = array();
				
				$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
				{
					$time = date('H:i:s', strtotime(pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour'] . ':' . $_POST['minute'] . ' ' . strtoupper($_POST['ampm'])));
				}else{
					$time = $_POST['hour'] . ":" . $_POST['minute'] . ":00";
				}
				$date_to = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
				if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
				{
					$time_to = date('H:i:s', strtotime(pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour_to'] . ':' . $_POST['minute_to'] . ' ' . strtoupper($_POST['ampm'])));
				}else{
					$time_to = $_POST['hour_to'] . ":" . $_POST['minute_to'] . ":00";
				}
				
				$data['dt'] = sprintf("%s %s", $date, $time); unset($_POST['date']);
				$data['dt_to'] = sprintf("%s %s", $date_to, $time_to); unset($_POST['date_to']);
				
				$opts = pjAppController::getPrice($this->option_arr, $date, $time, $_POST['code']);
				$data['total']   = $opts['total'];
				$data['ip'] = $_SERVER['REMOTE_ADDR'];
				
				if (isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_year'] . '-' . $_POST['cc_exp_month'];
				}
				
				$booking_id = $pjBookingModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($booking_id !== false)
				{
					$pjBookingTableModel = pjBookingTableModel::factory();
					if (isset($_POST['table_id']) && count($_POST['table_id']) > 0)
					{
						$data = array();
						$data['booking_id'] = $booking_id;
						foreach ($_POST['table_id'] as $table_id)
						{
							$data['table_id'] = $table_id;
							$pjBookingTableModel->reset()->setAttributes($data)->insert();
						}
					}
					$err = 'AB11';
				}else{
					$err = 'AB12';
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminBookings&action=pjActionIndex&err=$err");
			}else{
				
				$table_arr = pjTableModel::factory()->findAll()->getData();
								
				$date = isset($_GET['date']) ? pjUtil::formatDate($_GET['date'], $this->option_arr['o_date_format']) : date('Y-m-d');
				$date_from = isset($_GET['hour']) ? date('Y-m-d H:i:s', $_GET['hour']) : date('Y-m-d H:i:s'); 
				
				$country_arr = pjCountryModel::factory()
							->select('t1.id, t2.content AS country_title')
							->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->where('status', 'T')
							->orderBy('`country_title` ASC')->findAll()->getData();
				
				$wt_arr = pjAppController::getWorkingTime($date);			

				$this->set('table_arr', $table_arr);
				$this->set('wt_arr', $wt_arr);
				$this->set('country_arr', $country_arr);
				$this->set('date_from', $date_from);
				if(isset($_GET['table_id'])){
					
					$this->set('table', pjTableModel::factory()->find($_GET['table_id'])->getData());
				}
				
				$pjWorkingTimeModel = pjWorkingTimeModel::factory();
				$pjDateModel = pjDateModel::factory();
				$week_dayoff_arr = $pjWorkingTimeModel->getDaysOff(1);
				$date_arr = $pjDateModel->where("(t1.date > DATE(NOW()))")->orderBy('`date` ASC')->findAll()->getData();
				$this->set('week_dayoff_arr', $week_dayoff_arr);
				$this->set('date_arr', $date_arr);
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminBookings.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetTables()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjTableModel = pjTableModel::factory();
			$pjBookingTableModel = pjBookingTableModel::factory();
			if(isset($_POST['id']))
			{
				$dt_from = sprintf("%s %s:%s:00", pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']), $_POST['hour'], $_POST['minute']);
				$dt_to = sprintf("%s %s:%s:00", pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']), $_POST['hour_to'], $_POST['minute_to']);
			}else{
				$dt_from = sprintf("%s %s:%s:00", pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']), $_POST['hour'], $_POST['minute']);
				$dt_to = date("Y-m-d H:i:s", strtotime($dt_from) + $this->option_arr['o_booking_length'] * 60);
			}
						
			$pjBookingTableModel->join('pjBooking', "t2.id = t1.booking_id AND t2.status = 'confirmed' AND `dt` <= '".$dt_to."' AND `dt_to` >= '".$dt_from."'", 'inner');
			$bt_arr = $pjBookingTableModel->findAll()->getDataPair('table_id', 'table_id');
			
			if (count($bt_arr) > 0){
				$pjTableModel->where("(t1.id NOT IN('".join("','", $bt_arr)."'))");
			}
			$table_arr = $pjTableModel->orderBy("t1.name ASC")->findAll()->getData();
			
			$this->set('table_arr', $table_arr);
		}
	}

	public function pjActionPrinter()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->setLayout('pjActionPrint');
			
			$pjBookingModel = pjBookingModel::factory();
			$pjTableModel = pjTableModel::factory();
			
			$arr = $pjBookingModel->select('t1.*, t2.content as country_title')
								->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.c_country AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
								->find($_GET['id'])->getData();
			if (count($arr) === 0)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBookings&action=pjActionIndex&err=AB08");
			}
			$table_arr = $pjTableModel->orderBy("t1.name ASC")->findAll()->getData();
			$bt_arr = pjBookingTableModel::factory()->where('t1.booking_id', $arr['id'])->findAll()->getDataPair('table_id', 'id');
			
			$date = date('Y-m-d', strtotime($arr['dt']));
			$time = date('H:i:s', strtotime($arr['dt']));
			$price_arr = pjAppController::getPrice($this->option_arr, $date, $time, $arr['code']);
			
			$this->set('arr', $arr);
			$this->set('bt_arr', $bt_arr);
			$this->set('table_arr', $table_arr);
			$this->set('discount', isset($price_arr['discount_formated']) ? $price_arr['discount_formated'] : '');
			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionReminder()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['reminder']))
			{
				$pjEmail = new pjEmail();
				$from_email = $this->getAdminEmail();
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$pjEmail
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass'])
						->setSender($this->option_arr['o_smtp_user'])
					;
				}	
				$pjEmail
					->setContentType("text/html")
					->setTo($_POST['to'])
					->setFrom($from_email)
					->setSubject($_POST['subject']);
				if ($pjEmail->send(pjUtil::textToHtml($_POST['message'])))
				{
					$err = 'AB09';
				} else {
					$err = 'AB10';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBookings&action=pjActionIndex&err=$err");
			} else {
				
				$arr = pjBookingModel::factory()->find($_GET['id'])->getData();
				
				if (count($arr) === 0)
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBookings&action=pjActionIndex&err=AB08");
				}
				
				$table_arr = pjBookingTableModel::factory()->select('t1.*, t2.name')
								->join('pjTable', 't2.id = t1.table_id', 'inner')
								->where('t1.booking_id', $arr['id'])
								->findAll()->getData();
				
				$arr['table_arr'] = $table_arr;				
				$arr['data'] = pjAppController::getData($this->option_arr, $arr, PJ_SALT, $this->getLocaleId(), false);
				
				$lang_message = pjMultiLangModel::factory()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_confirmation_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
				$lang_subject = pjMultiLangModel::factory()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_confirmation_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
				
				$this->set('arr', $arr);
				$this->set('lang_subject', $lang_subject[0]['content']);
				$this->set('lang_message', $lang_message[0]['content']);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminBookings.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionAddPromo()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$resp = array();
			
			$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
			if(strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1)
			{
				$time = date('H:i:s', strtotime(pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']) . ' ' .$_POST['hour'] . ':' . $_POST['minute'] . ' ' . strtoupper($_POST['ampm'])));
			}else{
				$time = $_POST['hour'] . ":" . $_POST['minute'] . ":00";
			}

			$price_arr = pjAppController::getPrice($this->option_arr, $date, $time, $_POST['code']);
			$resp['total'] = $price_arr['total'];
			$resp['discount'] = isset($price_arr['discount_formated']) ? $price_arr['discount_formated'] : '';
			
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionConfirmation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['send_confirm']) && !empty($_POST['to']) && !empty($_POST['from']) &&
					!empty($_POST['subject']) && !empty($_POST['message']))
			{
				$Email = new pjEmail();
				$Email->setContentType('text/html');
				$from_email = $this->getAdminEmail();
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
					->setTransport('smtp')
					->setSmtpHost($this->option_arr['o_smtp_host'])
					->setSmtpPort($this->option_arr['o_smtp_port'])
					->setSmtpUser($this->option_arr['o_smtp_user'])
					->setSmtpPass($this->option_arr['o_smtp_pass'])
					->setSender($this->option_arr['o_smtp_user'])
					;
				}
	
				$subject = $_POST['subject'];
				$message = $_POST['message'];
				if (get_magic_quotes_gpc())
				{
					$subject = stripslashes($_POST['subject']);
					$message = stripslashes($_POST['message']);
				}
	
				$r = $Email
				->setTo($_POST['to'])
				->setFrom($from_email)
				->setSubject($subject)
				->send($message);
					
				if ($r)
				{
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Email has been sent.'));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Email failed to send.'));
			}
	
			if (isset($_GET['booking_id']) && (int) $_GET['booking_id'] > 0)
			{
				$pjMultiLangModel = pjMultiLangModel::factory();
				$lang_message = $pjMultiLangModel->reset()->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $this->getLocaleId())
				->where('t1.field', 'o_email_confirmation_message')
				->limit(0, 1)
				->findAll()->getData();
				$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $this->getLocaleId())
				->where('t1.field', 'o_email_confirmation_subject')
				->limit(0, 1)
				->findAll()->getData();
	
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$booking_arr = pjBookingModel::factory()->find($_GET['booking_id'])->getData();
					$booking_arr['table_arr'] = pjBookingTableModel::factory()->select("t1.*, t2.name")
					->join('pjTable', 't1.table_id = t2.id')
					->where('t1.booking_id', $booking_arr['id'])
					->findAll()->getData();
					$tokens = pjAppController::getData($this->option_arr, $booking_arr, PJ_SALT, $this->getLocaleId(), false);
					
					$subject_client = str_replace($tokens['search'], $tokens['replace'], $lang_subject[0]['content']);
					$message_client = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
	
					$this->set('arr', array(
							'to' => $booking_arr['c_email'],
							'from' => $this->getAdminEmail(),
							'message' => pjUtil::textToHtml($message_client),
							'subject' => $subject_client
					));
				}
			} else {
				exit;
			}
		}
	}
	public function pjActionCancellation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['send_cancellation']) && !empty($_POST['to']) && !empty($_POST['from']) &&
					!empty($_POST['subject']) && !empty($_POST['message']))
			{
				$from_email = $this->getAdminEmail();
				$Email = new pjEmail();
				$Email->setContentType('text/html');
				
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
					->setTransport('smtp')
					->setSmtpHost($this->option_arr['o_smtp_host'])
					->setSmtpPort($this->option_arr['o_smtp_port'])
					->setSmtpUser($this->option_arr['o_smtp_user'])
					->setSmtpPass($this->option_arr['o_smtp_pass'])
					->setSender($this->option_arr['o_smtp_user']);
				}
	
				$subject = $_POST['subject'];
				$message = $_POST['message'];
				if (get_magic_quotes_gpc())
				{
					$subject = stripslashes($_POST['subject']);
					$message = stripslashes($_POST['message']);
				}
	
				$r = $Email
				->setTo($_POST['to'])
				->setFrom($from_email)
				->setSubject($subject)
				->send($message);
					
				if ($r)
				{
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Email has been sent.'));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Email failed to send.'));
			}
	
			if (isset($_GET['booking_id']) && (int) $_GET['booking_id'] > 0)
			{
				$pjMultiLangModel = pjMultiLangModel::factory();
				$lang_message = $pjMultiLangModel->reset()->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $this->getLocaleId())
				->where('t1.field', 'o_email_cancel_message')
				->limit(0, 1)
				->findAll()->getData();
				$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $this->getLocaleId())
				->where('t1.field', 'o_email_cancel_subject')
				->limit(0, 1)
				->findAll()->getData();
	
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$booking_arr = pjBookingModel::factory()->find($_GET['booking_id'])->getData();
					$booking_arr['table_arr'] = pjBookingTableModel::factory()->select("t1.*, t2.name")
					->join('pjTable', 't1.table_id = t2.id')
					->where('t1.booking_id', $booking_arr['id'])
					->findAll()->getData();
					$tokens = pjAppController::getData($this->option_arr, $booking_arr, PJ_SALT, $this->getLocaleId(), false);
						
					$subject_client = str_replace($tokens['search'], $tokens['replace'], $lang_subject[0]['content']);
					$message_client = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
	
					$this->set('arr', array(
							'to' => $booking_arr['c_email'],
							'from' => $this->getAdminEmail(),
							'message' => pjUtil::textToHtml($message_client),
							'subject' => $subject_client
					));
				}
			} else {
				exit;
			}
		}
	}
}
?>