<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	public static function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
	
	public static function getWeekdays(){
		$arr = array();
		$arr[] = 'monday';
		$arr[] = 'tuesday';
		$arr[] = 'wednesday';
		$arr[] = 'thursday';
		$arr[] = 'friday';
		$arr[] = 'saturday';
		$arr[] = 'sunday';
		return $arr;
	}
	
	public static function getClass($arr, $hour)
	{
		$class = NULL;
		if (isset($arr[$hour]) && !empty($arr[$hour]))
		{
			$class = 'calendarStatus' . ucfirst($arr[$hour]['status']);
		}
		return $class;
	}
	
	public static function getTitles(){
		$arr = array();
		$arr[] = 'mr';
		$arr[] = 'mrs';
		$arr[] = 'ms';
		$arr[] = 'dr';
		$arr[] = 'prof';
		$arr[] = 'rev';
		$arr[] = 'other';
		return $arr;
	}
	
	public static function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
		
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	public static function hoursToSeconds($hour)
	{
    	$parse = array();
		if (!preg_match ('#^(?<hours>[\d]{2}):(?<mins>[\d]{2}):(?<secs>[\d]{2})$#',$hour,$parse))
		{
			throw new RuntimeException ("Hour Format not valid");
		}
		return (int) $parse['hours'] * 3600 + (int) $parse['mins'] * 60 + (int) $parse['secs'];
	}
	
	public static function checkDayAfter($wt_arr, $option_arr, $selected)
	{
		$status = false;
		
		$offset = $wt_arr['end_hour'] <= $wt_arr['start_hour'] ? 24 : 0;
		$booking_length = ceil((int) $option_arr['o_booking_length'] / 60);
		$start = (int) $wt_arr['start_hour'];
		$end = (int) $wt_arr['end_hour'] - $booking_length + $offset;
		if ($end < $start){
			$end = $start;
		}
		foreach (range($start, $end) as $v)
		{
			if($v >= 24)
			{
				$v = $v - 24;
				if($v == $selected)
				{
					$status = true;
				}
			}
		}
		return $status;
	}
	
	public static function toMomemtJS($format)
	{
		$f = str_replace(
				array('Y', 'm', 'n', 'd', 'j'),
				array('yyyy', 'mm', 'm', 'dd', 'd'),
				$format
		);
	
		return $f;
	}
}
?>