DROP TABLE IF EXISTS `restaurantbooking_bookings`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` int(10) unsigned default NULL,
  `dt` datetime default NULL,
  `dt_to` datetime default NULL,
  `people` smallint(5) unsigned default NULL,
  `code` varchar(255) default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `is_paid` enum('T','F') default 'F',
  `status` enum('confirmed','cancelled','pending','enquiry') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_fname` varchar(255) default NULL,
  `c_lname` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` varchar(255) default NULL,
  `cc_num` varchar(255) default NULL,
  `cc_exp` varchar(255) default NULL,
  `cc_code` varchar(255) default NULL,
  `reminder_email` tinyint(1) unsigned default '0',
  `reminder_sms` tinyint(1) unsigned default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `dt` (`dt`),
  KEY `dt_to` (`dt_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_bookings_tables`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_bookings_tables` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `table_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `booking_table_id` (`booking_id`,`table_id`),
  KEY `booking_id` (`booking_id`),
  KEY `table_id` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_tables`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_tables` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `width` smallint(5) unsigned default NULL,
  `height` smallint(5) unsigned default NULL,
  `top` smallint(5) unsigned default NULL,
  `left` smallint(5) unsigned default NULL,
  `name` varchar(255) default NULL,
  `seats` smallint(5) unsigned default NULL,
  `minimum` smallint(5) unsigned default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_working_times`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_working_times` (
  `id` int(10) unsigned NOT NULL default '0',
  `monday_from` time default NULL,
  `monday_to` time default NULL,
  `monday_dayoff` enum('T','F') default 'F',
  `tuesday_from` time default NULL,
  `tuesday_to` time default NULL,
  `tuesday_dayoff` enum('T','F') default 'F',
  `wednesday_from` time default NULL,
  `wednesday_to` time default NULL,
  `wednesday_dayoff` enum('T','F') default 'F',
  `thursday_from` time default NULL,
  `thursday_to` time default NULL,
  `thursday_dayoff` enum('T','F') default 'F',
  `friday_from` time default NULL,
  `friday_to` time default NULL,
  `friday_dayoff` enum('T','F') default 'F',
  `saturday_from` time default NULL,
  `saturday_to` time default NULL,
  `saturday_dayoff` enum('T','F') default 'F',
  `sunday_from` time default NULL,
  `sunday_to` time default NULL,
  `sunday_dayoff` enum('T','F') default 'F',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_dates`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_dates` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `date` date NOT NULL default '0000-00-00',
  `start_time` time default NULL,
  `end_time` time default NULL,
  `is_dayoff` enum('T','F') default 'F',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `date` (`date`),
  KEY `is_dayoff` (`is_dayoff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_vouchers`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_vouchers` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `code` varchar(255) default NULL,
  `type` enum('amount','percent') default NULL,
  `discount` decimal(9,2) unsigned default NULL,
  `valid` enum('fixed','period','recurring') default NULL,
  `date_from` date default NULL,
  `date_to` date default NULL,
  `time_from` time default NULL,
  `time_to` time default NULL,
  `every` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_fields`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_multi_lang`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_options`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_roles`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `restaurantbooking_users`;
CREATE TABLE IF NOT EXISTS `restaurantbooking_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'menuRestaurant', 'backend', 'Menu / Restaurant', 'script', NULL),
(309, 'menuBooking', 'backend', 'Menu / Booking', 'script', NULL),
(310, 'menuVouchers', 'backend', 'Menu / Vouchers', 'script', NULL),
(311, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(312, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(313, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(314, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(315, 'infoBookingsTitle', 'backend', 'Infobox / Bookings title', 'script', NULL),
(316, 'infoBookingsBody', 'backend', 'Infobox / Bookings body', 'script', NULL),
(318, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(319, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(320, 'opt_o_booking_price', 'backend', 'Options / Deposit fee', 'script', NULL),
(321, 'opt_o_booking_price_text', 'backend', 'Options / Booking price text', 'script', NULL),
(322, 'opt_o_booking_length', 'backend', 'Options / Booking length', 'script', NULL),
(323, 'opt_o_booking_length_text', 'backend', 'Options / Booking length text', 'script', NULL),
(324, 'opt_o_booking_earlier', 'backend', 'Options / Book X hours earlier', 'script', NULL),
(325, 'opt_o_booking_earlier_text', 'backend', 'Options / Book X hours earlier text', 'script', NULL),
(326, 'opt_o_booking_status', 'backend', 'Options / Default booking status', 'script', NULL),
(327, 'opt_o_booking_status_text', 'backend', 'Options / Default booking status text', 'script', NULL),
(328, 'opt_o_payment_status', 'backend', 'Options / booking status after payment', 'script', NULL),
(329, 'opt_o_payment_status_text', 'backend', 'Options / booking status after payment', 'script', NULL),
(330, 'opt_o_thank_you_page', 'backend', 'Options / "Thank you" page location', 'script', NULL),
(331, 'opt_o_thank_you_page_text', 'backend', 'Options / "Thank you" page location', 'script', NULL),
(332, 'opt_o_payment_disable', 'backend', 'Options / Disable payments', 'script', NULL),
(333, 'opt_o_payment_disable_text', 'backend', 'Options / Disable payments text', 'script', NULL),
(334, 'opt_o_allow_paypal', 'backend', 'Options / Allow PayPal payments', 'script', NULL),
(335, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(336, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net', 'script', NULL),
(337, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(338, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(339, 'opt_o_allow_cash', 'backend', 'Options / Allow payments with cash', 'script', NULL),
(340, 'opt_o_allow_creditcard', 'backend', 'Options / Allow payments with Credit cards', 'script', NULL),
(341, 'opt_o_allow_bank', 'backend', 'Option / Allow bank account', 'script', NULL),
(342, 'opt_o_bank_account', 'backend', 'Options / bank account', 'script', NULL),
(343, 'menuBookingForm', 'backend', 'Menu / Booking form', 'script', NULL),
(344, 'menuConfirmation', 'backend', 'Menu / Confirmation', 'script', NULL),
(345, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(346, 'menuReminder', 'backend', 'Menu / Reminder', 'script', NULL),
(347, 'infoConfirmationTitle', 'backend', 'Infobox / Confirmation title', 'script', NULL),
(348, 'infoConfirmationDesc', 'backend', 'Infobox / Confirmation description', 'script', NULL),
(349, 'opt_o_email_address', 'backend', 'Options / Notification email address', 'script', NULL),
(350, 'opt_o_email_confirmation', 'backend', 'Options / Send confirmation email', 'script', NULL),
(351, 'opt_o_email_confirmation_text', 'backend', 'Options / Send confirmation email', 'script', NULL),
(352, 'opt_o_email_confirmation_subject', 'backend', 'Options / Confirmation subject', 'script', NULL),
(353, 'opt_o_email_confirmation_message_text', 'backend', 'Options / confirmation message', 'script', NULL),
(354, 'opt_o_email_confirmation_message', 'backend', 'Options / Confirmation message', 'script', NULL),
(355, 'opt_o_email_payment', 'backend', 'Optoins / Send payment confirmation email', 'script', NULL),
(356, 'opt_o_email_payment_text', 'backend', 'Optoins / Send payment confirmation email', 'script', NULL),
(357, 'opt_o_email_payment_message', 'backend', 'Options / Payment email message', 'script', NULL),
(358, 'opt_o_email_payment_message_text', 'backend', 'Options / payment message', 'script', NULL),
(359, 'opt_o_email_enquiry', 'backend', 'Options / Send enquiry email', 'script', NULL),
(360, 'opt_o_email_enquiry_text', 'backend', 'Options / Send enquiry email text', 'script', NULL),
(361, 'opt_o_email_enquiry_subject', 'backend', 'Options / Enquiry email subject', 'script', NULL),
(362, 'opt_o_email_enquiry_message', 'backend', 'Options / Enquiry email message', 'script', NULL),
(363, 'opt_o_email_enquiry_message_text', 'backend', 'Options / Enquiry email message', 'script', NULL),
(364, 'opt_o_email_payment_subject', 'backend', 'Options / Payment email subject', 'script', NULL),
(365, 'opt_o_email_cancel', 'backend', 'Optons / Send cancel email', 'script', NULL),
(366, 'opt_o_email_cancel_text', 'backend', 'Optons / Send cancel email text', 'script', NULL),
(367, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel email subject', 'script', NULL),
(368, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel email message', 'script', NULL),
(369, 'opt_o_email_cancel_message_text', 'backend', 'Options / Cancel email message text', 'script', NULL),
(421, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form title', 'script', NULL),
(422, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form descriptoin', 'script', NULL),
(423, 'opt_o_bf_include_title', 'backend', 'Options / Title included', 'script', NULL),
(424, 'opt_o_bf_include_text', 'backend', 'Options / include text', 'script', NULL),
(425, 'opt_o_bf_include_fname', 'backend', 'Options / First name', 'script', NULL),
(426, 'opt_o_bf_include_lname', 'backend', 'Options / Last name', 'script', NULL),
(427, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(428, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(429, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(430, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(431, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(432, 'opt_o_bf_include_promo', 'backend', 'Options / Voucher', 'script', NULL),
(433, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(434, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(435, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(436, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(437, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(438, 'infoTermsTitle', 'backend', 'Infobox / Terms title', 'script', NULL),
(439, 'infoTermsDesc', 'backend', 'Infobox / Terms description', 'script', NULL),
(440, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(441, 'opt_o_enquiry', 'backend', 'Options / Enquiry', 'script', NULL),
(442, 'infoReminderTitle', 'backend', 'Infobox / Reminder Options', 'script', NULL),
(443, 'infoReminderDesc', 'backend', 'Infobox / Reminder Options desc', 'script', NULL),
(444, 'opt_o_reminder_enable', 'backend', 'Options / Enable notifications', 'script', NULL),
(445, 'opt_o_reminder_email_before', 'backend', 'Optoins / Send email reminder', 'script', NULL),
(446, 'opt_o_reminder_subject', 'backend', 'Options / Email Reminder subject', 'script', NULL),
(447, 'opt_o_reminder_body', 'backend', 'Options / Email Reminder body', 'script', NULL),
(448, 'opt_o_reminder_body_text', 'backend', 'Options / Email Reminder body text', 'script', NULL),
(449, 'opt_o_reminder_sms_hours', 'backend', 'Optoins / Send SMS reminder', 'script', NULL),
(450, 'opt_o_reminder_sms_api', 'backend', 'Optoins / SMS api key', 'script', NULL),
(451, 'opt_o_reminder_sms_message', 'backend', 'Optoins / SMS message', 'script', NULL),
(452, 'opt_o_reminder_sms_message_text', 'backend', 'Options / SMS message text', 'script', NULL),
(453, 'opt_o_reminder_cron', 'backend', 'Options / Cron script', 'script', NULL),
(454, 'opt_o_reminder_cron_text', 'backend', 'Option / Cron text', 'script', NULL),
(455, 'lblHoursBefore', 'backend', 'Label / hours before', 'script', NULL),
(456, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(457, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(458, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(459, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(460, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(461, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(462, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(463, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(464, 'lblGetKey', 'backend', 'Lable / get key', 'script', NULL),
(555, 'lblVoucherCode', 'backend', 'Label / Voucher code', 'script', NULL),
(556, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL),
(558, 'lblValid', 'backend', 'Label / Valid', 'script', NULL),
(559, 'lblAddVoucher', 'backend', 'Label / Add voucher', 'script', NULL),
(560, 'infoVoucherListTitle', 'backend', 'Infobox / Voucher list title', 'script', NULL),
(561, 'infoVoucherListDesc', 'backend', 'Infobox / Voucher list description', 'script', NULL),
(562, 'lblVoucherCodeExist', 'backend', 'Label / Existing voucher code', 'script', NULL),
(563, 'infoAddVoucherTitle', 'backend', 'Infobox / Add Voucher', 'script', NULL),
(564, 'infoAddVoucherDesc', 'backend', 'Infobox / Add Voucher description', 'script', NULL),
(565, 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL),
(566, 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL),
(567, 'voucher_valids_ARRAY_fixed', 'arrays', 'voucher_valids_ARRAY_fixed', 'script', NULL),
(568, 'voucher_valids_ARRAY_period', 'arrays', 'voucher_valids_ARRAY_period', 'script', NULL),
(569, 'voucher_valids_ARRAY_recurring', 'arrays', 'voucher_valids_ARRAY_recurring', 'script', NULL),
(570, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(571, 'lblTimeFrom', 'backend', 'Label / Time from', 'script', NULL),
(572, 'lblTimeTo', 'backend', 'Label / Time to', 'script', NULL),
(573, 'lblDateTimeFrom', 'backend', 'Label / From date time', 'script', NULL),
(574, 'lblDateTimeTo', 'backend', 'Label / To date/time', 'script', NULL),
(575, 'voucher_days_ARRAY_monday', 'arrays', 'voucher_days_ARRAY_monday', 'script', NULL),
(576, 'voucher_days_ARRAY_tuesday', 'arrays', 'voucher_days_ARRAY_tuesday', 'script', NULL),
(577, 'voucher_days_ARRAY_wednesday', 'arrays', 'voucher_days_ARRAY_wednesday', 'script', NULL),
(578, 'voucher_days_ARRAY_thursday', 'arrays', 'voucher_days_ARRAY_thursday', 'script', NULL),
(579, 'voucher_days_ARRAY_friday', 'arrays', 'voucher_days_ARRAY_friday', 'script', NULL),
(580, 'voucher_days_ARRAY_saturday', 'arrays', 'voucher_days_ARRAY_saturday', 'script', NULL),
(581, 'voucher_days_ARRAY_sunday', 'arrays', 'voucher_days_ARRAY_sunday', 'script', NULL),
(582, 'lblEvery', 'backend', 'Label / Every', 'script', NULL),
(583, 'error_titles_ARRAY_AV01', 'arrays', 'error_titles_ARRAY_AV01', 'script', NULL),
(584, 'error_bodies_ARRAY_AV01', 'arrays', 'error_bodies_ARRAY_AV01', 'script', NULL),
(585, 'error_titles_ARRAY_AV03', 'arrays', 'error_titles_ARRAY_AV03', 'script', NULL),
(586, 'error_bodies_ARRAY_AV03', 'arrays', 'error_bodies_ARRAY_AV03', 'script', NULL),
(587, 'error_titles_ARRAY_AV04', 'arrays', 'error_titles_ARRAY_AV04', 'script', NULL),
(588, 'error_bodies_ARRAY_AV04', 'arrays', 'error_bodies_ARRAY_AV04', 'script', NULL),
(589, 'error_titles_ARRAY_AV08', 'arrays', 'error_titles_ARRAY_AV08', 'script', NULL),
(590, 'error_bodies_ARRAY_AV08', 'arrays', 'error_bodies_ARRAY_AV08', 'script', NULL),
(591, 'lblUpdateVoucher', 'backend', 'Label / Update voucher', 'script', NULL),
(592, 'infoUpdateVoucherTitle', 'backend', 'Infobox / Update voucher', 'script', NULL),
(593, 'infoUpdateVoucherDesc', 'backend', 'Infobox / Update voucher desc', 'script', NULL),
(594, 'menuWorkingTime', 'backend', 'Menu / Working Time', 'script', NULL),
(595, 'menuSeatMap', 'backend', 'Menu / Seat Map', 'script', NULL),
(596, 'menuTables', 'backend', 'Menu / Tables', 'script', NULL),
(597, 'lblDefault', 'backend', 'Label / Default', 'script', NULL),
(598, 'lblCustom', 'backend', 'Label / Custom', 'script', NULL),
(599, 'lblDayOfWeek', 'backend', 'Label / Day of Week', 'script', NULL),
(600, 'lblStartTime', 'backend', 'Label / Start Time', 'script', NULL),
(601, 'lblEndTime', 'backend', 'Label / End Time', 'script', NULL),
(602, 'lblIsDayOff', 'backend', 'Label / Is Day off', 'script', NULL),
(603, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(604, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(605, 'error_titles_ARRAY_AT02', 'arrays', 'error_titles_ARRAY_AT02', 'script', NULL),
(606, 'error_bodies_ARRAY_AT02', 'arrays', 'error_bodies_ARRAY_AT02', 'script', NULL),
(697, 'lblMap', 'backend', 'Label / Map', 'script', NULL),
(698, 'lblOptions', 'backend', 'Label / Options', 'script', NULL),
(699, 'infoMapTitle', 'backend', 'Infobox / Seat Map', 'script', NULL),
(700, 'infoMapDesc', 'backend', 'Infobox / Seat Map desc', 'script', NULL),
(701, 'infoMapOptionsTitle', 'backend', 'Infobox / Hot spot size', 'script', NULL),
(702, 'infoMapOptionsDesc', 'backend', 'Infobox / Hot spot size desc', 'script', NULL),
(703, 'lblUseSeatMap', 'backend', 'Label / Use seat map', 'script', NULL),
(704, 'lblFile', 'backend', 'Label / File', 'script', NULL),
(705, 'lblDeleteMap', 'backend', 'Label / Delete map', 'script', NULL),
(706, 'lblDeleteMapConfirm', 'backend', 'Label / Delete map confirm', 'script', NULL),
(707, 'lblUpdateMapTitle', 'backend', 'Label / Update Map', 'script', NULL),
(708, 'lblUpdateMapDesc', 'backend', 'Label / Update map desc', 'script', NULL),
(709, 'lblCapacity', 'backend', 'Label / Capacity', 'script', NULL),
(710, 'lblMinimum', 'backend', 'Label / Minimum', 'script', NULL),
(711, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(712, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(713, 'infoUseMapDesc', 'backend', 'Infobox / User map desc', 'script', NULL),
(714, 'lblWidth', 'backend', 'Label / Width', 'script', NULL),
(715, 'lblHeight', 'backend', 'Label / Height', 'script', NULL),
(716, 'lblTableList', 'backend', 'Label / Table list', 'script', NULL),
(717, 'lblAddTable', 'backend', 'Label / Add table', 'script', NULL),
(718, 'infoAddTableTitle', 'backend', 'Infobox / Add new table', 'script', NULL),
(719, 'infoAddTableDesc', 'backend', 'Infobox / Add new table desc', 'script', NULL),
(720, 'lblTableNameExist', 'backend', 'Label / Table name used', 'script', NULL),
(721, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(722, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(723, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(724, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(725, 'error_titles_ARRAY_AT05', 'arrays', 'error_titles_ARRAY_AT05', 'script', NULL),
(726, 'error_bodies_ARRAY_AT05', 'arrays', 'error_bodies_ARRAY_AT05', 'script', NULL),
(727, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(728, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(729, 'lblUpdateTable', 'backend', 'Label / Update table', 'script', NULL),
(730, 'infoUpdateTableTitle', 'backend', 'Infobox / Update table title', 'script', NULL),
(731, 'infoUpdateTableDesc', 'backend', 'Infobox / Update table desc', 'script', NULL),
(732, 'lblUpdate', 'backend', 'Label / Update', 'script', NULL),
(733, 'menuSchedule', 'backend', 'Menu / Schedule', 'script', NULL),
(734, 'menuBookingList', 'backend', 'Menu / Booking List', 'script', NULL),
(735, 'menuPrint', 'backend', 'Menu / Print', 'script', NULL),
(736, 'lblFilter', 'backend', 'Label / Filter', 'script', NULL),
(737, 'lblNoTable', 'backend', 'Label / No tables found', 'script', NULL),
(738, 'lblDateIsDayOff', 'backend', 'Label / Date is day off', 'script', NULL),
(739, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(740, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(741, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(742, 'booking_statuses_ARRAY_enquiry', 'arrays', 'booking_statuses_ARRAY_enquiry', 'script', NULL),
(743, 'lblFromDateTime', 'backend', 'Label / From date time', 'script', NULL),
(744, 'opt_o_datetime_format', 'backend', 'Options / Date/time format', 'script', NULL),
(745, 'lblDateFrom', 'backend', 'Label / Date from', 'script', NULL),
(746, 'lblDateTo', 'backend', 'Label / Date to', 'script', NULL),
(747, 'lblTable', 'backend', 'Label / Table', 'script', NULL),
(748, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(749, 'error_titles_ARRAY_AB08', 'arrays', 'error_titles_ARRAY_AB08', 'script', NULL),
(750, 'error_bodies_ARRAY_AB08', 'arrays', 'error_bodies_ARRAY_AB08', 'script', NULL),
(751, 'lblBookingDetails', 'backend', 'Label / Booking Details', 'script', NULL),
(752, 'lblClientDetails', 'backend', 'Label / Client Details', 'script', NULL),
(753, 'lblUpdateBooking', 'backend', 'Label / Update Booking', 'script', NULL),
(754, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(755, 'lblDepositPaid', 'backend', 'Label / Deposit paid', 'script', NULL),
(756, 'booking_is_paids_ARRAY_T', 'arrays', 'booking_is_paids_ARRAY_T', 'script', NULL),
(757, 'booking_is_paids_ARRAY_F', 'arrays', 'booking_is_paids_ARRAY_F', 'script', NULL),
(758, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(759, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(760, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(761, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(762, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(763, 'lblPaymentMethod', 'backend', 'Label / Payment Method', 'script', NULL),
(764, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(765, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(766, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(767, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(768, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(769, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(770, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(771, 'lblCCCode', 'backend', 'Label / CC security code', 'script', NULL),
(772, 'lblBookingTotal', 'backend', 'Label / Total', 'script', NULL),
(773, 'lblPeople', 'backend', 'Label / People', 'script', NULL),
(774, 'lblTableName', 'backend', 'Label / Table name', 'script', NULL),
(775, 'lblViewAvailability', 'backend', 'Label / View availability', 'script', NULL),
(776, 'lblBookingAvailability', 'backend', 'Label / Availability', 'script', NULL),
(777, 'name_titles_ARRAY_mr', 'arrays', 'name_titles_ARRAY_mr', 'script', NULL),
(778, 'name_titles_ARRAY_mrs', 'arrays', 'name_titles_ARRAY_mrs', 'script', NULL),
(779, 'name_titles_ARRAY_ms', 'arrays', 'name_titles_ARRAY_ms', 'script', NULL),
(780, 'name_titles_ARRAY_dr', 'arrays', 'name_titles_ARRAY_dr', 'script', NULL),
(781, 'name_titles_ARRAY_prof', 'arrays', 'name_titles_ARRAY_prof', 'script', NULL),
(782, 'name_titles_ARRAY_rev', 'arrays', 'name_titles_ARRAY_rev', 'script', NULL),
(783, 'name_titles_ARRAY_other', 'arrays', 'name_titles_ARRAY_other', 'script', NULL),
(784, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(785, 'lblBookingFname', 'backend', 'Label / First name', 'script', NULL),
(786, 'lblBookingLname', 'backend', 'Label / Last name', 'script', NULL),
(787, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(788, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(789, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(790, 'lblBookingCompany', 'backend', 'Label / Company name', 'script', NULL),
(791, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(792, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(793, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(794, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(795, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(796, 'error_titles_ARRAY_AB05', 'arrays', 'error_titles_ARRAY_AB05', 'script', NULL),
(797, 'error_bodies_ARRAY_AB05', 'arrays', 'error_bodies_ARRAY_AB05', 'script', NULL),
(798, 'lblBookingPrint', 'backend', 'Label / Print Booking Details', 'script', NULL),
(799, 'lblBookingRemind', 'backend', 'Label / Re-send confirmation', 'script', NULL),
(800, 'lblBookingID', 'backend', 'Label / ID', 'script', NULL),
(801, 'lblBookingCreated', 'backend', 'Label / Created', 'script', NULL),
(802, 'lblBookingTxnID', 'backend', 'Label / Txn ID', 'script', NULL),
(803, 'lblBookingProcessedOn', 'backend', 'Label / Processed on', 'script', NULL),
(805, 'infoReminderEmailTitle', 'backend', 'Infobox / Reminder email title', 'script', NULL),
(806, 'infoReminderEmailDesc', 'backend', 'Infobox / Reminder email desc', 'script', NULL),
(807, 'lblReminderTo', 'backend', 'Label / To', 'script', NULL),
(808, 'lblReminderSubject', 'backend', 'Label / Subject', 'script', NULL),
(809, 'lblReminderMessage', 'backend', 'Label / Message', 'script', NULL),
(810, 'error_titles_ARRAY_AB09', 'arrays', 'error_titles_ARRAY_AB09', 'script', NULL),
(811, 'error_bodies_ARRAY_AB09', 'arrays', 'error_bodies_ARRAY_AB09', 'script', NULL),
(812, 'error_titles_ARRAY_AB10', 'arrays', 'error_titles_ARRAY_AB10', 'script', NULL),
(813, 'error_bodies_ARRAY_AB10', 'arrays', 'error_bodies_ARRAY_AB10', 'script', NULL),
(814, 'lblClientName', 'backend', 'Label / Client name', 'script', NULL),
(815, 'lblPerson', 'backend', 'label / Person', 'script', NULL),
(816, 'lblNoBookings', 'backend', 'Label / No bookings', 'script', NULL),
(817, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(818, 'lblInstallJs1_title', 'backend', 'Install / Install code', 'script', NULL),
(819, 'lblInstallJs1_body', 'backend', 'Install / Install code body', 'script', NULL),
(820, 'lblInstallConfig', 'backend', 'Label / Language options', 'script', NULL),
(821, 'lblInstallConfigLocale', 'backend', 'Label / Language', 'script', NULL),
(822, 'lblInstallConfigHide', 'backend', 'Label / Hide language selector ', 'script', NULL),
(823, 'lblInstallJs1_1', 'backend', 'Label / Step 1', 'script', NULL),
(824, 'front_label_select_date_time', 'frontend', 'Label / Select date time', 'script', NULL),
(825, 'front_label_date', 'frontend', 'Label / Date', 'script', NULL),
(826, 'front_label_time', 'frontend', 'Label / Time', 'script', NULL),
(827, 'front_label_people', 'frontend', 'Label / People', 'script', NULL),
(828, 'front_label_check_availability', 'frontend', 'Label / Check Availability', 'script', NULL),
(829, 'front_label_avail_title', 'frontend', 'Label / Available for', 'script', NULL),
(830, 'front_label_book', 'frontend', 'Book', 'script', NULL),
(831, 'front_label_send_enquiry', 'frontend', 'Label / Send Enquiry', 'script', NULL),
(832, 'front_no_available_table', 'frontend', 'Label / No table', 'script', NULL),
(833, 'front_label_selected_tables', 'frontend', 'Label / Selected table(s)', 'script', NULL),
(834, 'front_label_your_booking', 'frontend', 'Label / Your booking', 'script', NULL),
(835, 'front_label_booking_form', 'frontend', 'Label / Booking form', 'script', NULL),
(926, 'front_label_date_time', 'frontend', 'Label / Date and time', 'script', NULL),
(927, 'front_label_table_for', 'frontend', 'Label / Table for person', 'script', NULL),
(928, 'front_label_change', 'frontend', 'Label / change', 'script', NULL),
(929, 'front_label_title', 'frontend', 'Label / Title', 'script', NULL),
(930, 'front_label_fname', 'frontend', 'Label / First name', 'script', NULL),
(931, 'front_label_lname', 'frontend', 'Label / Last name', 'script', NULL),
(932, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(933, 'front_label_email', 'backend', 'Label / Email', 'script', NULL),
(934, 'front_label_company', 'frontend', 'Label / Company name', 'script', NULL),
(935, 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL),
(936, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(937, 'front_label_city', 'frontend', 'Label / City', 'script', NULL),
(938, 'front_label_state', 'frontend', 'Label / State', 'script', NULL),
(939, 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL),
(940, 'front_label_country', 'frontend', 'Label / Country', 'script', NULL),
(941, 'front_label_checkout', 'frontend', 'Label / Checkout', 'script', NULL),
(942, 'front_label_discount', 'frontend', 'Label / discount', 'script', NULL),
(943, 'front_label_deposit_note', 'frontend', 'Label / Deposit note', 'script', NULL),
(944, 'front_label_price', 'frontend', 'Label / Price', 'script', NULL),
(945, 'front_label_voucher', 'frontend', 'Label / Voucher', 'script', NULL),
(946, 'front_label_add_voucher', 'frontend', 'Label / Add Voucher', 'script', NULL),
(947, 'front_label_added_voucher', 'frontend', 'Label / Added voucher', 'script', NULL),
(948, 'front_label_remove_voucher', 'frontend', 'Label / Remove voucher', 'script', NULL),
(949, 'front_label_invalid_voucher', 'frontend', 'Label / Invalid voucher', 'script', NULL),
(950, 'front_label_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(951, 'front_label_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(952, 'front_label_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(953, 'front_label_cc_exp', 'frontend', 'Label / CC expiration date', 'script', NULL),
(954, 'front_label_cc_code', 'frontend', 'Label / CC security code', 'script', NULL),
(955, 'front_label_captcha', 'frontend', 'Captcha', 'script', NULL),
(1046, 'front_label_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(1047, 'front_label_invalid_email', 'frontend', 'Label / Email is not valid.', 'script', NULL),
(1048, 'front_label_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(1049, 'front_label_exp_month', 'frontend', 'Label / Expiration month is required.', 'script', NULL),
(1050, 'front_label_exp_year', 'frontend', 'Label / Expiration year is required.', 'script', NULL),
(1051, 'front_label_agree', 'frontend', 'Label / Agreements', 'script', NULL),
(1052, 'front_label_terms_conditions', 'frontend', 'Label / Terms and Conditions', 'script', NULL),
(1053, 'front_label_booking_summary', 'frontend', 'Label / Booking summary', 'script', NULL),
(1054, 'front_label_confirm', 'frontend', 'Label / Confirm Booking', 'script', NULL),
(1055, 'front_label_back', 'frontend', 'Label / Back', 'script', NULL),
(1056, 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL),
(1057, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(1058, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(1059, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(1060, 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', NULL),
(1061, 'front_messages_ARRAY_0', 'arrays', 'front_messages_ARRAY_0', 'script', NULL),
(1062, 'front_label_missing_params', 'frontend', 'Label / Missing params', 'script', NULL),
(1063, 'front_label_restaurant_reservations', 'frontend', 'Label / Restaurant Reservations', 'script', NULL),
(1064, 'front_label_cancel_note', 'frontend', 'Label / Cancel note', 'script', NULL),
(1065, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(1066, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(1067, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(1068, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(1069, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(1070, 'front_label_cancel_heading', 'frontend', 'Label / Cancel Heading', 'script', NULL),
(1071, 'front_label_cancel_from', 'frontend', 'Label / Cancel from', 'script', NULL),
(1072, 'front_label_cancel_people', 'frontend', 'Label / People', 'script', NULL),
(1073, 'front_label_cancel_code', 'frontend', 'Label / Promo code', 'script', NULL),
(1074, 'front_label_cancel_title', 'frontend', 'Label / Title', 'script', NULL),
(1075, 'front_label_cancel_description', 'frontend', 'Label / Description', 'script', NULL),
(1076, 'front_label_cancel_datetime', 'frontend', 'Label / Date/time', 'script', NULL),
(1077, 'front_label_cancel_fname', 'frontend', 'Label / First name', 'script', NULL),
(1078, 'front_label_cancel_lname', 'frontend', 'Label / Last name', 'script', NULL),
(1079, 'front_label_cancel_email', 'frontend', 'Label / Email', 'script', NULL),
(1080, 'front_label_cancel_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1081, 'front_label_cancel_company', 'frontend', 'Label / Company', 'script', NULL),
(1082, 'front_label_cancel_country', 'frontend', 'Label / Country', 'script', NULL),
(1083, 'front_label_cancel_city', 'frontend', 'Label / City', 'script', NULL),
(1084, 'front_label_cancel_state', 'frontend', 'Label / State', 'script', NULL),
(1085, 'front_label_cancel_zip', 'frontend', 'Label / Zip', 'script', NULL),
(1086, 'front_label_cancel_address', 'frontend', 'Label / Address', 'script', NULL),
(1087, 'front_label_cancel_payment', 'frontend', 'Label / Payment', 'script', NULL),
(1088, 'front_label_cancel_total', 'frontend', 'Label / Total', 'script', NULL),
(1089, 'front_label_cancel_table', 'frontend', 'Label / Table', 'script', NULL),
(1090, 'front_label_cancel_confirm', 'frontend', 'Label / Table', 'script', NULL),
(1091, 'front_label_cancel_personal', 'frontend', 'Label / Personal Details', 'script', NULL),
(1182, 'front_label_cancel', 'frontend', 'Label / Cancel', 'script', NULL),
(1183, 'front_label_intro_text', 'frontend', 'Label / Intro text', 'script', NULL),
(1184, 'front_label_loading_tables', 'frontend', 'Label / loading tables', 'script', NULL),
(1185, 'infoWTimeTitle', 'backend', 'Infobox / Working Time Settings', 'script', NULL),
(1186, 'infoWTimeDesc', 'backend', 'Infobox / Working Time Desc', 'script', NULL),
(1187, 'front_label_dayoff', 'frontend', 'Label / Day off', 'script', NULL),
(1188, 'lblToday', 'backend', 'Label / Today', 'script', NULL),
(1189, 'lblTomorrow', 'backend', 'Label / Tomorrow', 'script', NULL),
(1190, 'front_messages_ARRAY_300', 'arrays', 'front_messages_ARRAY_300', 'script', NULL),
(1191, 'front_messages_ARRAY_301', 'arrays', 'front_messages_ARRAY_301', 'script', NULL),
(1192, 'front_messages_ARRAY_302', 'arrays', 'front_messages_ARRAY_302', 'script', NULL),
(1193, 'front_messages_ARRAY_303', 'arrays', 'front_messages_ARRAY_303', 'script', NULL),
(1194, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(1195, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(1196, 'lblTableHour', 'backend', 'Label / Table / Hour', 'script', NULL),
(1198, 'menuAddBooking', 'backend', 'Menu / Add Booking', 'script', NULL),
(1199, 'lblBookingPrice', 'backend', 'Label / Price', 'script', NULL),
(1202, 'error_titles_ARRAY_AB11', 'arrays', 'error_titles_ARRAY_AB11', 'script', NULL),
(1203, 'error_bodies_ARRAY_AB11', 'arrays', 'error_bodies_ARRAY_AB11', 'script', NULL),
(1204, 'error_titles_ARRAY_AB12', 'arrays', 'error_titles_ARRAY_AB12', 'script', NULL),
(1206, 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(1297, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(1388, 'menuBookings', 'backend', 'Menu / Reservations', 'script', NULL),
(1389, 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL),
(1390, 'lblOptionAdministrator', 'backend', 'Label / Option Administrator', 'script', NULL),
(1391, 'front_label_intro_text2', 'frontend', 'Label / Intro text 2', 'script', NULL),
(1392, 'lblBack', 'backend', 'Lable / Back', 'script', NULL),
(1393, 'front_label_start_over', 'frontend', 'Label / Error start over', 'script', NULL),
(1394, 'lblDepositFee', 'backend', 'Label / Deposit fee', 'script', NULL),
(1395, 'infoScheduleTitle', 'backend', 'Infobox / Schedule Title', 'script', NULL),
(1396, 'infoScheduleDesc', 'backend', 'Infobox / Schedule Desc', 'script', NULL),
(1397, 'infoAddBookingTitle', 'backend', 'Infobox / Add Booking Title', 'script', NULL),
(1398, 'infoAddBookingDesc', 'backend', 'Infobox / Add booking Desc', 'script', NULL),
(1399, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1400, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking desc', 'script', NULL),
(1401, 'infoBookingListTitle', 'backend', 'Infobox / Bookings list', 'script', NULL),
(1402, 'infoBookingListDesc', 'backend', 'Infobox / Reservations list desc', 'script', NULL),
(1494, 'infoConfirmation2Title', 'backend', 'Infobox / Confirmation Admin Title', 'script', NULL),
(1495, 'infoConfirmation2Desc', 'backend', 'Infobox / Confirmation Admin Desc', 'script', NULL),
(1498, 'lblMadeOn', 'backend', 'Label / Made on', 'script', NULL),
(1499, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(1500, 'front_cancel_reservation', 'frontend', 'Label / Cancel reservation', 'script', NULL),
(1501, 'front_cron_completed', 'frontend', 'Label / CRON job completed.', 'script', NULL),
(1502, 'lblPositiveNumber', 'backend', 'Label / Please enter positive number', 'script', NULL),
(1503, 'lblValidateMinimum', 'backend', 'Label / Validate minimum', 'script', NULL),
(1504, 'uuid_used', 'backend', 'Label / Unique ID was used.', 'script', NULL),
(1505, 'lblValidateTime', 'backend', 'Label / Validate time', 'script', NULL),
(1506, 'lblValidateDateTime', 'backend', 'Label / Validate date time', 'script', NULL),
(1507, 'front_label_price_after', 'frontend', 'Label / Price after discount applied', 'script', NULL),
(1508, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(1509, 'lblValidateVoucherDateTime', 'backend', 'Label / Validate date time', 'script', NULL),
(1510, 'front_label_out_range_voucher', 'frontend', 'Label / Out of range voucher', 'script', NULL),
(1511, 'lblReservationID', 'backend', 'Label / Reservation ID', 'script', NULL);

INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Reservations Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Reservation Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Restaurant', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Reservation', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Vouchers', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Reservation options', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Modify the options below and click Save button.', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Reservation options updated', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'All changes made to the Reservation options have been saved.', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Deposit fee', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'set default reservation price', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Default reservation length, value is in minutes', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'set the default reservation length, values in minutes', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Reserve X hours earlier', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'how many hours earlier, you can reserve a table', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'All reservations which are only made but NOT paid will be set with the following status:', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'set the default status for each reservation after it is made', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'All reservations which are made and paid will be set with the following status:', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'set the default status for each reservation after payment is made for it', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'this is the page where people will be redirected after paying', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments and only collect reservation details', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'to disable payments and only accept reservations, set this to "Yes"', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Allow payments with Paypal', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Allow payment with cash', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Reservation form', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Reminder', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Email Confirmations', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'There are 4 types of email confirmations - one after reservation form is submitted , one after payment is made, one is enquiry email and one when cancelled the reservation. Use the available tokens to personalize the email messages.', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Notification email address', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Send confirmation email', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'select if and when confirmation email should be sent to clients after they make a reservation', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Confirmation email subject', 'script'),
(NULL, 353, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{Table}<br/>\r\n{People}<br/>\r\n{BookingID}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Confirmation email message', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'select if and when confirmation email should be sent to clients after they make a payment for their booking', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Payment email message', 'script'),
(NULL, 358, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{Table}<br/>\r\n{People}<br/>\r\n{BookingID}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Send enquiry email', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'select if and when confirmation email should be sent to clients after they make a enquiry for booking', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Enquiry email subject', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Enquiry email message', 'script'),
(NULL, 363, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{People}<br/>\r\n{UniqueID}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Payment email subject', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Send cancel email', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'select if and when confirmation email should be sent to clients after they cancel for their booking', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Cancel email subject', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Cancel email message', 'script'),
(NULL, 369, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{Table}<br/>\r\n{People}<br/>\r\n{BookingID}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Reservation Form Options', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Choose the fields that should be available on the reservation form and click SAVE button.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Select "Yes" if you want to include the field on the reservation form, otherwise select "No"', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Voucher', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Please write down the Terms and Conditions for making reservation and click SAVE button.', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Enquiry', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Reminder Options', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Let set the options for Reminder and click SAVE button. It includes email notification and SMS message.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Enable notifications', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Send email reminder', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Email Reminder subject', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Email Reminder message', 'script'),
(NULL, 448, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{Table}<br/>\r\n{People}<br/>\r\n{BookingID}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Send SMS reminder', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'SMS api key', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'SMS message', 'script'),
(NULL, 452, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{DtFrom}<br/>\r\n{Table}<br/>\r\n{People}<br/>\r\n{BookingID}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Cron script', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'You need to set up a cron job using your hosting account control panel which should execute every hour. Depending on your web server you should use either the URL or script path.\r\n<br /><br/>\r\nServer path:<br /><span class="bold">{PATH}</span>\r\n<br /><br />\r\nURL:<br /><span class="bold">{URL}</span>', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'hours before', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Reservation Form Options Updated', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Your settings for reservation form have been saved successfully.', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Confirmation Options Updated', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Your settings for confirmation have been saved successfully.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Terms and Conditions updated', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'All changes you made on the Terms and Conditions options have been saved.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Reminder updated', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Your settings for reminder options have been saved successfully.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'get key', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Voucher code', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Valid', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Add voucher', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Voucher List', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Below is the list of vouchers. If you wan to add new voucher, let click on the "Add voucher" Tab. To edit or delete a certain voucher, let click on corresponding icons on the row. You can also export the list of vouchers or delete multiple selected vouchers by using the popup menu at the bottom of the table.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'The voucher code is already used.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Add Voucher', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Please fill out the for below to add voucher code and discount. You can add a voucher for specif date, day of the week or date range.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Fixed', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Recurring', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Time from', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Time to', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'From date/time', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'To date/time', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Every', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Voucher updated', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'All changes made to the voucher have been saved.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Voucher added', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'A new voucher has been added to the list. You can now add another voucher.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Voucher failed to add', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'We sorry that the voucher could not bee added successfully.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Voucher not found', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Voucher you are looking for is missing.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Update voucher', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Update voucher', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Please make any change you want on the form below to update voucher information and click SAVE button.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Working Time', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Seat Map', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Tables', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Default', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Custom', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Day of Week', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Start Time', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'End Time', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Is Day off', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Working Time Updated', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'All changes made to the working time have been saved.', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Custom working time saved', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Custom working time has been saved successfully.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Seat Map', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Check ''Use seat map'' checkbox to enable map table selection. You need to upload a JPG image map of your restaurant. Once image is uploaded click on the map to create a click-able hot spot for each table. You can click on each hot spot and position it on the map. To delete a hot spot click on it and then click on ''Delete'' button. To rename a hot spot (table) and set people capacity just click on it.', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Hot spot sizes', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Below you can set the size for the hot spots that you create on the map. You can create different sized hot spots on each map. Just enter the desired size, click on Save button and go to Update map tab to create the new hot spot. Visit <a href="http://www.phpjabbers.com/knowledgebase.php?product=134" target="_blank">Knowledgebase</a> to watch video showing how to create a map.', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Use seat map', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Delete this image file', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Are you sure you want to delete this image file? If yes, the image file will be deleted and will not be possible to restore it.', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Update Map', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Add a custom name for this spot on the map (VIP sector, Sector A, etc..). Also set how many available seats can be reserved in this sector.', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Minimum', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Map settings updated', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'All settings made to the map have been saved.', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'You are using a seat map.', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Width', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Height', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Table list', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Add table', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Add new table', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Add new table and set number of people allowed to reserve a table. For example if Minimum is set to 2 and Capacity is set to 4 then only reservation for 2, 3 or 4 people will be accepted for this table.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Table name was already used.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Table added', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'A new table has been added to the list.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Table failed to add', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'We are sorry that the table could not be added successfully.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Table updated', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'All changes made to the table have been saved.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Table not found', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'The table you are looking for is missing.', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Update table', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Update table', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'On the for below you can set number of people allowed to reserve a table. For example if Minimum is set to 2 and Capacity is set to 4 then only reservation for 2, 3 or 4 people will be accepted for this table.', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Reservations List', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Filter', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'No tables found', 'script'),
(NULL, 738, 'pjField', 1, 'title', '%s is day off', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Enquiry', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'From date/time', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Date/time format', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Date from', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Date to', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Table', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Reservation not found', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'We are sorry that the reservation you are looking for is missing.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Reservation Details', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Update Reservation', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Deposit paid', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Paypal', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'CC security code', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'People', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Table name', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'View availability', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Mr', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Mrs', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Ms', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Dr', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Prof', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Rev', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'County/Region/State', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Postcode/Zip', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Reservation updated', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'All changes made to the reservation have been saved.', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Print Reservation Details', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Re-send confirmation email', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Reminder email', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'You can make any change on the form below and click SEND button to send the reminder message.', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Reminder email sent', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'The reminder email has been sent to the give email address.', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Reminder failed to send', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'The reminder email could not be sent successfully. Please check again.', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Client name', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'Person', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'No reservations found', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Language options', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Hide language selector', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Step 1 (Required)', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Select date and time<br/>for your reservation', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'People', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Check Availability', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Available tables for %1s person(s) on %2s at %3s<br/><span>click on a table to book it<span>', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Book', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Send Enquiry', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'There is no table available<br/><span>click on SEND ENQUIRY button to make an enquiry</span>', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Selected table', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Your booking<br/><span>booking details</span>', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Reservation form<br/><span>fill the form to reserve a table</span>', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'Date and time', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'Table for %s person(s)', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'change selection', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'discount', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Payment is required to secure your reservation', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'Voucher', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Add Voucher', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'Added voucher', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'Remove voucher', 'script'),
(NULL, 949, 'pjField', 1, 'title', 'Invalid voucher', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'CC security code', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1046, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'Expiration month is required.', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'Expiration year is required.', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'I have read and accept reservation', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'Reservation summary<br/><span>detail information</span>', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Confirm Reservation', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1056, 'pjField', 1, 'title', 'Reservation failed to save.', 'script'),
(NULL, 1057, 'pjField', 1, 'title', 'Your reservation is saved. Redirecting to PayPal...', 'script'),
(NULL, 1058, 'pjField', 1, 'title', 'Your reservation is saved. Redirecting to Authorize.net...', 'script'),
(NULL, 1059, 'pjField', 1, 'title', 'Your reservation is saved. [STAG]Start over[ETAG].', 'script'),
(NULL, 1060, 'pjField', 1, 'title', 'Your enquiry has been sent. [STAG]Start over[ETAG].', 'script'),
(NULL, 1061, 'pjField', 1, 'title', 'Reservation is being processed...', 'script'),
(NULL, 1062, 'pjField', 1, 'title', 'Error! Some parameters are missing. ', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Restaurant Reservations', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'Cancel Reservation', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Reservation with such ID does not exist.', 'script'),
(NULL, 1067, 'pjField', 1, 'title', 'Security hash did not match', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'Reservation is already cancelled.', 'script'),
(NULL, 1069, 'pjField', 1, 'title', 'Reservation has been cancelled successfully.', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Your reservation details', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'Date/Time From', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'People', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Promo code', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1076, 'pjField', 1, 'title', 'Date/time', 'script'),
(NULL, 1077, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Table', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'Cancel Reservation', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1183, 'pjField', 1, 'title', '%1s available table(s) found.<br/>click on a table to reserve it', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Loading tables ...', 'script'),
(NULL, 1185, 'pjField', 1, 'title', 'Working Time Settings', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Below is the form to set the working time for the restaurant. You can also set different settings for some specific dates by clicking on the Tab Custom.', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'There is no working time for day off.', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 1190, 'pjField', 1, 'title', 'The selected date is day off.', 'script'),
(NULL, 1191, 'pjField', 1, 'title', 'You must reserve [HOUR] hours before.', 'script'),
(NULL, 1192, 'pjField', 1, 'title', 'We are not open yet.', 'script'),
(NULL, 1193, 'pjField', 1, 'title', 'We are close.', 'script'),
(NULL, 1194, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 1195, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 1196, 'pjField', 1, 'title', 'Table / Hour', 'script'),
(NULL, 1198, 'pjField', 1, 'title', 'Add Reservation', 'script'),
(NULL, 1199, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1202, 'pjField', 1, 'title', 'Reservation Added', 'script'),
(NULL, 1203, 'pjField', 1, 'title', 'A new reservation has been added to the list.', 'script'),
(NULL, 1204, 'pjField', 1, 'title', 'Reservation could not be added.', 'script'),
(NULL, 1206, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1297, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 1388, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1389, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 1390, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 1391, 'pjField', 1, 'title', 'Please send an enquiry and we will manually confirm your reservation.', 'script'),
(NULL, 1392, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1393, 'pjField', 1, 'title', 'Error! Please, [STAG]start over[ETAG]', 'script'),
(NULL, 1394, 'pjField', 1, 'title', 'Deposit fee', 'script'),
(NULL, 1395, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 1396, 'pjField', 1, 'title', 'By default below you see today''s schedule. Use the date picker to switch to any date. You can also print the schedule by clicking on the Print button.', 'script'),
(NULL, 1397, 'pjField', 1, 'title', 'Add new reservation', 'script'),
(NULL, 1398, 'pjField', 1, 'title', 'Fill in the form below to add a new reservation.', 'script'),
(NULL, 1399, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 1400, 'pjField', 1, 'title', 'Update reservation details', 'script'),
(NULL, 1401, 'pjField', 1, 'title', 'Reservations list', 'script'),
(NULL, 1402, 'pjField', 1, 'title', 'Below you can see all the reservations and enquiries made. Click on any of them to view and edit it. Using the buttons you can filter the reservation by their status. Use the advance search to quickly locate a reservation.', 'script'),
(NULL, 1494, 'pjField', 1, 'title', 'Email Confirmations', 'script'),
(NULL, 1495, 'pjField', 1, 'title', 'There are 4 types of email confirmations - one after reservation form is submitted , one after payment is made, one is enquiry email and one when cancelled the reservation. Use the available tokens to personalize the email messages.', 'script'),
(NULL, 1498, 'pjField', 1, 'title', 'Made on', 'script'),
(NULL, 1499, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 1500, 'pjField', 1, 'title', 'Cancel reservation', 'script'),
(NULL, 1501, 'pjField', 1, 'title', 'CRON job completed.', 'script'),
(NULL, 1502, 'pjField', 1, 'title', 'Please enter positive number.', 'script'),
(NULL, 1503, 'pjField', 1, 'title', 'Minimum cannot be greater than capacity.', 'script'),
(NULL, 1504, 'pjField', 1, 'title', 'Unique ID was used.', 'script'),
(NULL, 1505, 'pjField', 1, 'title', 'End time must be greater than start time.', 'script'),
(NULL, 1506, 'pjField', 1, 'title', 'To date/time must be greater than From date/time.', 'script'),
(NULL, 1507, 'pjField', 1, 'title', 'Price after discount applied', 'script'),
(NULL, 1508, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 1509, 'pjField', 1, 'title', 'From date/time must be greater than To date/time.', 'script'),
(NULL, 1510, 'pjField', 1, 'title', 'Voucher is out of range date or time.', 'script'),
(NULL, 1511, 'pjField', 1, 'title', 'Reservation ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjOption', 1, 'o_reminder_subject', 'Booking Reminder', 'data'),
(NULL, 1, 'pjOption', 1, 'o_reminder_body', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_reminder_sms_message', '{FirstName}, booking reminder\r\n\r\n{Table}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_enquiry', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Confirmation message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel booking message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'You''ve just cancel a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_enquiry_subject', 'Enquiry message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_enquiry_message', 'You''ve just made an enquiry.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nEnquiry details:\r\nDate/Time From: {DtFrom}\r\nPeople: {People}\r\nUnique ID: {UniqueID}\r\n\r\nIf you want to cancel your enquiry follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'Confirmation message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', 'You''ve just received a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'Payment message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', 'You''ve just receive the payment for the following booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_enquiry_subject', 'Enquiry message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_enquiry_message', 'You''ve just received an enquiry.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nEnquiry details:\r\nDate/Time From: {DtFrom}\r\nPeople: {People}\r\nUnique ID: {UniqueID}\r\n\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Cancel booking message', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', 'A booking has been cancelled.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data');

INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_datetime_format', 1, 'd.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s::d-m-Y, H:i', 'd.m.Y, H:i (25.09.2010, 09:51)|d.m.Y, H:i:s (25.09.2010, 09:51:47)|m.d.Y, H:i (09.25.2010, 09:51)|m.d.Y, H:i:s (09.25.2010, 09:51:47)|Y.m.d, H:i (2010.09.25, 09:51)|Y.m.d, H:i:s (2010.09.25, 09:51:47)|j.n.Y, H:i (25.9.2010, 09:51)|j.n.Y, H:i:s (25.9.2010, 09:51:47)|n.j.Y, H:i (9.25.2010, 09:51)|n.j.Y, H:i:s (9.25.2010, 09:51:47)|Y.n.j, H:i (2010.9.25, 09:51)|Y.n.j, H:i:s (2010.9.25, 09:51:47)|d/m/Y, H:i (25/09/2010, 09:51)|d/m/Y, H:i:s (25/09/2010, 09:51:47)|m/d/Y, H:i (09/25/2010, 09:51)|m/d/Y, H:i:s (09/25/2010, 09:51:47)|Y/m/d, H:i (2010/09/25, 09:51)|Y/m/d, H:i:s (2010/09/25, 09:51:47)|j/n/Y, H:i (25/9/2010, 09:51)|j/n/Y, H:i:s (25/9/2010, 09:51:47)|n/j/Y, H:i (9/25/2010, 09:51)|n/j/Y, H:i:s (9/25/2010, 09:51:47)|Y/n/j, H:i (2010/9/25, 09:51)|Y/n/j, H:i:s (2010/9/25, 09:51:47)|d-m-Y, H:i (25-09-2010, 09:51)|d-m-Y, H:i:s (25-09-2010, 09:51:47)|m-d-Y, H:i (09-25-2010, 09:51)|m-d-Y, H:i:s (09-25-2010, 09:51:47)|Y-m-d, H:i (2010-09-25, 09:51)|Y-m-d, H:i:s (2010-09-25, 09:51:47)|j-n-Y, H:i (25-9-2010, 09:51)|j-n-Y, H:i:s (25-9-2010, 09:51:47)|n-j-Y, H:i (9-25-2010, 09:51)|n-j-Y, H:i:s (9-25-2010, 09:51:47)|Y-n-j, H:i (2010-9-25, 09:51)|Y-n-j, H:i:s (2010-9-25, 09:51:47)', 'enum', 4, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 5, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 6, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_booking_price', 2, '50', NULL, 'float', 2, 1, NULL),
(1, 'o_booking_length', 2, '180', NULL, 'int', 3, 1, NULL),
(1, 'o_booking_earlier', 2, '2', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thank_you_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 7, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 8, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 10, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 11, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 12, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 14, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 16, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 18, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 19, 1, NULL),

(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_email_enquiry_subject', 3, '', NULL, 'string', 9, 1, NULL),
(1, 'o_email_enquiry_message', 3, '', NULL, 'text', 10, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_enquiry_subject', 3, '', NULL, 'string', 9, 1, NULL),
(1, 'o_admin_email_enquiry_message', 3, '', NULL, 'text', 10, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_bf_include_title', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_fname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_lname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_company', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_address', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_notes', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_promo', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_city', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_state', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_zip', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_country', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
(1, 'o_bf_include_captcha', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),

(1, 'o_terms', 5, '', NULL, 'text', 1, 1, NULL),
(1, 'o_enquiry', 5, '', NULL, 'text', 2, 1, NULL),

(1, 'o_reminder_enable', 6, 'Yes|No::Yes', 'Yes|No', 'enum', 1, 1, NULL),
(1, 'o_reminder_cron', 6, '', NULL, 'text', 2, 1, NULL),
(1, 'o_reminder_email_before', 6, '2', NULL, 'int', 3, 1, NULL),
(1, 'o_reminder_subject', 6, '', NULL, 'string', 4, 1, NULL),
(1, 'o_reminder_body', 6, '', NULL, 'text', 5, 1, NULL),
(1, 'o_reminder_sms_hours', 6, '2', NULL, 'int', 6, 1, NULL),
(1, 'o_reminder_sms_message', 6, '', NULL, 'text', 7, 1, NULL),

(1, 'o_use_map', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `restaurantbooking_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `restaurantbooking_working_times` (`id`, `monday_from`, `monday_to`, `monday_dayoff`, `tuesday_from`, `tuesday_to`, `tuesday_dayoff`, `wednesday_from`, `wednesday_to`, `wednesday_dayoff`, `thursday_from`, `thursday_to`, `thursday_dayoff`, `friday_from`, `friday_to`, `friday_dayoff`, `saturday_from`, `saturday_to`, `saturday_dayoff`, `sunday_from`, `sunday_to`, `sunday_dayoff`) VALUES
(1, '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', NULL, NULL, 'T');