/*
 * Decompiled with CFR 0.152.
 */
public class LinkedQueue {
    protected LinkedNode head_;
    protected int count_ = 0;
    protected final Object lastMonitor_ = new Object();
    protected LinkedNode last_ = this.head_ = new LinkedNode(null);
    protected int waitingForTake_ = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object object) {
        Object object2 = this.lastMonitor_;
        synchronized (object2) {
            LinkedNode linkedNode;
            this.last_.next = linkedNode = new LinkedNode(object);
            this.last_ = linkedNode;
            ++this.count_;
            if (this.count_ > 1000 && this.count_ % 1000 == 0) {
                System.out.println("In Queue : " + this.count_);
            }
            if (this.waitingForTake_ > 0) {
                this.lastMonitor_.notify();
            }
        }
    }

    protected synchronized Object extract() {
        Object object = null;
        LinkedNode linkedNode = this.head_.next;
        if (linkedNode != null) {
            object = linkedNode.value;
            linkedNode.value = null;
            this.head_ = linkedNode;
            --this.count_;
        }
        return object;
    }

    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(object);
    }

    public boolean offer(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(object);
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.extract();
        if (object != null) {
            return object;
        }
        Object object2 = this.lastMonitor_;
        synchronized (object2) {
            try {
                ++this.waitingForTake_;
                while (true) {
                    if ((object = this.extract()) != null) {
                        --this.waitingForTake_;
                        return object;
                    }
                    this.lastMonitor_.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                --this.waitingForTake_;
                this.lastMonitor_.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized Object peek() {
        LinkedNode linkedNode = this.head_.next;
        if (linkedNode != null) {
            return linkedNode.value;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        return this.head_.next == null;
    }

    public Object poll(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.extract();
        if (object != null) {
            return object;
        }
        Object object2 = this.lastMonitor_;
        synchronized (object2) {
            try {
                long l2 = l;
                long l3 = l <= 0L ? 0L : System.currentTimeMillis();
                ++this.waitingForTake_;
                while (true) {
                    if ((object = this.extract()) != null || l2 <= 0L) {
                        --this.waitingForTake_;
                        return object;
                    }
                    this.lastMonitor_.wait(l2);
                    l2 = l - (System.currentTimeMillis() - l3);
                }
            }
            catch (InterruptedException interruptedException) {
                --this.waitingForTake_;
                this.lastMonitor_.notify();
                throw interruptedException;
            }
        }
    }

    class LinkedNode {
        Object value;
        LinkedNode next = null;

        LinkedNode(Object object) {
            this.value = object;
        }

        LinkedNode(Object object, LinkedNode linkedNode) {
            this.value = object;
            this.next = linkedNode;
        }
    }
}

